import tkinter
import tkinter.messagebox
import random

FS = ("Times New Roman", 30)
FL = ("Times New Roman", 80)
BLACK = 1
WHITE = 2
mx = 0
my = 0
mc = 0
proc = 0
turn = 0
msg = ""
space = 0
color = [0]*2
who = ["あなた", "コンピュータ"]
"""board = [
    [0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 2, 1, 0, 0, 0],
    [0, 0, 0, 1, 2, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0],
    [0, 0, 0, 0, 0, 0, 0, 0]
]"""
board = []
back = []
for y in range(8):
    board.append([0]*8)
    back.append([0]*8)


def click(e):
    global mx, my, mc
    mc = 1
    mx = int(e.x/80)  # 盤面のX軸は0～7、マス目のwidthが80
    my = int(e.y/80)  # 盤面のY軸は0～7、マス目のheightが80
    if mx > 7:
        mx = 7
    if my > 7:
        my = 7
    """if board[mx][my] == 0:
        #board[mx][my] = BLACK
        ishi_utsu(mx, my, BLACK)"""
    """elif board[mx][my] == BLACK:
        board[mx][my] = WHITE
    elif board[mx][my] == WHITE:
        board[mx][my] = 0"""
    # banmen()


def banmen():
    cvs.delete("all")
    cvs.create_text(320, 670, text=msg, fill="silver", font=FS)
    for y in range(8):
        for x in range(8):
            X = x*80
            Y = y*80
            cvs.create_rectangle(X, Y, X+80, Y+80, outline="black")
            if board[y][x] == BLACK:
                cvs.create_oval(X+10, Y+10, X+70, Y+70, fill="black", width=0)
            if board[y][x] == WHITE:
                cvs.create_oval(X+10, Y+10, X+70, Y+70, fill="white", width=0)
            """if kaeseru(x, y, BLACK) > 0:
                cvs.create_oval(X+5, Y+5, X+75, Y+75, outline="cyan", width=2)"""
    if proc != 0:  # Macでのタイトル画面の文字のちらつき対策として、cvs.update()をif文の処理内に移動
        cvs.update()


# 盤面を初期化する
def ban_syokika():
    global space
    space = 60
    for y in range(8):
        for x in range(8):
            board[y][x] = 0
    board[3][4] = BLACK
    board[4][3] = BLACK
    board[3][3] = WHITE
    board[4][4] = WHITE


# 石を打ち、相手の石をひっくり返す
def ishi_utsu(x, y, iro):
    board[y][x] = iro
    for dy in range(-1, 2):
        for dx in range(-1, 2):
            k = 0  # ひっくり返す事が出来る相手の石がいくつ並んでいるかを数えるための変数
            sx = x
            sy = y
            while True:  # ここが無限ループなのでdxとdyの値がどんどん増減していき（-1なら無限に1引かれていき、1なら無限に1足されていく）、それに伴い調べるマス目が広がっていき、最終的に全てのマス目を調べられる
                sx += dx
                sy += dy
                if sx < 0 or sx > 7 or sy < 0 or sy > 7:
                    break
                if board[sy][sx] == 0:
                    break
                if board[sy][sx] == 3-iro:
                    k += 1
                if board[sy][sx] == iro:
                    for i in range(k):  # k=0だと0回の繰り返しなのでどの石もひっくり返らない
                        sx -= dx
                        sy -= dy
                        board[sy][sx] = iro
                    break


# そこに打つといくつ返せるか数える
def kaeseru(x, y, iro):
    if board[y][x] > 0:  # 置けないマス
        return -1
    total = 0
    for dy in range(-1, 2):
        for dx in range(-1, 2):
            k = 0  # ひっくり返す事が出来る相手の石がいくつ並んでいるかを数えるための変数
            sx = x
            sy = y
            while True:  # ここが無限ループなのでdxとdyの値がどんどん増減していき（-1なら無限に1引かれていき、1なら無限に1足されていく）、それに伴い調べるマス目が広がっていき、最終的に全てのマス目を調べられる
                sx += dx
                sy += dy
                if sx < 0 or sx > 7 or sy < 0 or sy > 7:
                    break
                if board[sy][sx] == 0:
                    break
                if board[sy][sx] == 3-iro:
                    k += 1
                if board[sy][sx] == iro:
                    total += k
                    break
    return total


# 打てるマスがあるか調べる
def uteru_masu(iro):
    for y in range(8):
        for x in range(8):
            if kaeseru(x, y, iro) > 0:
                return True
    return False


# 黒い石と白い石がいくつあるか数える
def ishino_kazu():
    b = 0
    w = 0
    for y in range(8):
        for x in range(8):
            if board[y][x] == BLACK:
                b += 1
            if board[y][x] == WHITE:
                w += 1
    return b, w


# コンピュータの思考ルーチン
"""def computer_0(iro):  # ランダムに打つ
    while True:
        rx = random.randint(0, 7)
        ry = random.randint(0, 7)
        if kaeseru(rx, ry, iro) > 0:
            return rx, ry  # Pythonは関数の戻り値に複数の変数を指定出来る"""
"""point = [
    [6, 2, 5, 4, 4, 5, 2, 6],
    [2, 1, 3, 3, 3, 3, 1, 2],
    [5, 3, 3, 3, 3, 3, 3, 5],
    [4, 3, 3, 0, 0, 3, 3, 4],
    [4, 3, 3, 0, 0, 3, 3, 4],
    [5, 3, 3, 3, 3, 3, 3, 5],
    [2, 1, 3, 3, 3, 3, 1, 2],
    [6, 2, 5, 4, 4, 5, 2, 6]
]


def computer_1(iro):  # 優先的に打つべきマスを選ぶ
    sx = 0
    sy = 0
    p = 0
    for y in range(8):
        for x in range(8):
            if kaeseru(x, y, iro) > 0 and point[y][x] > p:
                p = point[y][x]
                sx = x
                sy = y
    return sx, sy"""


# モンテカルロ法による思考ルーチン
def save():
    for y in range(8):
        for x in range(8):
            back[y][x] = board[y][x]


def load():
    for y in range(8):
        for x in range(8):
            board[y][x] = back[y][x]


def uchiau(iro):
    while True:
        if uteru_masu(BLACK) == False and uteru_masu(WHITE) == False:
            break
        iro = 3-iro
        if uteru_masu(iro) == True:
            while True:
                x = random.randint(0, 7)
                y = random.randint(0, 7)
                if kaeseru(x, y, iro) > 0:
                    ishi_utsu(x, y, iro)
                    break


def computer_2(iro, loops):  # 引数loopsは、ランダムに打ち合い勝敗を調べることを何回行うかを指定する
    global msg
    win = [0]*64
    save()
    for y in range(8):
        for x in range(8):
            if kaeseru(x, y, iro) > 0:
                msg += "."  # コンピュータの思考中であることを分かりやすくするため、「コンピュータ考え中...」という文字列のピリオドを増やすために、msg += "."でピリオドを追加した上でbanmen()で盤面を描き直している
                banmen()
                # 全ての打てるマスに打っても負けが確定している場合、リストwin[]は加算されないが、ここで打てるマスのリストwin[]に1を代入しておけば、下のfor i in range(64)のブロックにあるif win[i] > mの条件式が負けが確定している場合でも成立するため、この場合でも打つマスを決めることが出来る
                # x+y*8は、マスの位置（board[y][x]）のインデックス番号が、x軸方向で0行目は0～7、1行目は8～15、・・・となり、これをy軸方向で見ると0列目は0,8,16,24,32,40,48,56となり、1列目は1,9,17,25,33,41,49,57、・・となるため、x+y*8とリストwin[]のインデックス番号を指定。
                win[x+y*8] = 1
                for i in range(loops):
                    ishi_utsu(x, y, iro)
                    uchiau(iro)
                    b, w = ishino_kazu()
                    if iro == BLACK and b > w:
                        win[x+y*8] += 1
                    if iro == WHITE and w > b:
                        win[x+y*8] += 1
                    load()
    m = 0
    n = 0
    for i in range(64):
        if win[i] > m:
            m = win[i]  # リストwinの要素の値
            n = i  # iはマスの番号（リストwinのインデックス番号）
    x = n % 8  # x軸方向のマスの番号は、0行目は0～7、1行目は8～15、・・・の様になる
    # y軸方向のマスの番号は、0列目は0,8,16,24,32,40,48,56となり、1列目は1,9,17,25,33,41,49,57、・・・の様になる　例.win[13]だとxは5、yは1になる
    y = int(n/8)
    return x, y


# メイン処理を行う関数
def main():
    global mc, proc, turn, msg, space
    banmen()
    if proc == 0:  # タイトル画面
        msg = "先手、後手を選んで下さい"
        cvs.create_text(320, 200, text="リバーシ", fill="gold", font=FL)
        cvs.create_text(160, 440, text="先手（黒）", fill="lime", font=FS)
        cvs.create_text(480, 440, text="後手（白）", fill="lime", font=FS)
        if mc == 1:  # ウィンドウをクリック
            mc = 0
            if(mx == 1 or mx == 2) and my == 5:
                ban_syokika()
                color[0] = BLACK
                color[1] = WHITE
                turn = 0
                proc = 1
            if(mx == 5 or mx == 6) and my == 5:
                ban_syokika()
                color[0] = WHITE
                color[1] = BLACK
                turn = 1
                proc = 1
    elif proc == 1:  # どちらの番か表示
        msg = "あなたの番です"
        if turn == 1:
            msg = "コンピュータ考え中"
        proc = 2
    elif proc == 2:  # 石を打つマスを決める
        if turn == 0:  # プレイヤー
            if mc == 1:
                mc = 0
                if kaeseru(mx, my, color[turn]) > 0:
                    ishi_utsu(mx, my, color[turn])
                    space -= 1
                    proc = 3
        else:  # コンピュータ
            # computer_数字()関数の戻り値が2つ指定され、それを代入する変数も2つ用意する必要がある
            #cx, cy = computer_1(color[turn])
            # モンテカルロ法の試行回数（引数loops）用のリスト
            MONTE = [300, 300, 240, 180, 150, 60, 1]
            # 盤上の空きマスの数（space（ban_syokika()関数で60を代入し、石を打つごとに1減っていく））に応じて引数loopsの値を変えてcomputer_2関数を呼び出す
            cx, cy = computer_2(color[turn], MONTE[int(space/10)])
            ishi_utsu(cx, cy, color[turn])
            space -= 1
            proc = 3
    elif proc == 3:  # 打つ番を交代
        msg = ""
        turn = 1-turn
        proc = 4
    elif proc == 4:  # 打てるマスがあるか
        if space == 0:
            proc = 5
        elif uteru_masu(BLACK) == False and uteru_masu(WHITE) == False:
            tkinter.messagebox.showinfo("", "どちらも打てないので終了です")
            proc = 5
        elif uteru_masu(color[turn]) == False:
            tkinter.messagebox.showinfo("", who[turn]+"は打てないのでパスです")
            proc = 3
        else:
            proc = 1
    elif proc == 5:  # 勝敗判定
        b, w = ishino_kazu()
        tkinter.messagebox.showinfo("終了", "黒={}、白={}".format(b, w))
        if(color[0] == BLACK and b > w) or (color[0] == WHITE and w > b):
            tkinter.messagebox.showinfo("", "あなたの勝ち！")
        elif(color[1] == BLACK and b > w) or (color[1] == WHITE and w > b):
            tkinter.messagebox.showinfo("", "コンピュータの勝ち！")
        else:
            tkinter.messagebox.showinfo("", "引き分け")
        proc = 0
    root.after(100, main)


root = tkinter.Tk()
root.title("リバーシ")
root.resizable(False, False)
root.bind("<Button>", click)
cvs = tkinter.Canvas(width=640, height=700, bg="green")
cvs.pack()
root.after(100, main)
root.mainloop()
