#from email.mime import image
import tkinter
import time

FNT = ("Times New Roman", 60)
mx = 0
my = 0
mc = 0
proc = 0
tmr = 0
you_x = 750
you_y = 300
you_vx = 0
you_vy = 0
com_x = 250
com_y = 300
com_vx = 0
com_vy = 0
pu_x = 500
pu_y = 300
pu_vx = 10
pu_vy = 5
level = 0  # ゲームの難易度。ノーマルは０、ハードは１
point_you = 0
point_com = 0
POINT_WIN = 5
goal = [0, 0]
ts = 0


def click(e):
    global mc
    mc = 1


def move(e):
    global mx, my
    mx = e.x
    my = e.y


def draw_table():
    global ts
    cvs.delete("all")
    # ２フレームに１回ゴールの位置に黄色の矩形を描く事により、パックがゴールに入った時の点滅の演出を行う
    for i in range(2):
        if goal[i] > 0:
            goal[i] -= 1
            if goal[i] % 2 == 0:
                cvs.create_rectangle(980*i, 180, 980*i+20, 420, fill="yellow")
    cvs.create_image(500, 300, image=img_table)
    cvs.create_image(pu_x, pu_y, image=img_puck)
    cvs.create_image(you_x, you_y, image=img_sma_b)
    cvs.create_image(com_x, com_y, image=img_sma_r)
    cvs.create_text(500, 40, text=str(point_com)+"ー" +
                    str(point_you), font=FNT, fill="white")
    if proc == 0:
        cvs.create_image(500, 160, image=img_title)
        cvs.create_text(250, 440, text="ノーマル", font=FNT, fill="lime")
        cvs.create_text(750, 440, text="ハード", font=FNT, fill="gold")
        ts = time.time()
    # 変更点：経過時間を表示するように変更
    if proc == 1:
        if point_you == POINT_WIN:
            cvs.create_text(800, 40, text="時間"+str(int(time.time()-ts)) +
                            "秒", font=FNT, fill="white")
        else:
            cvs.create_text(800, 40, text="時間"+str(int(time.time()-ts)) +
                            "秒", font=FNT, fill="white")
    if proc == 2:
        if point_you == POINT_WIN:
            cvs.create_text(1000-tmr*10, 300, text="あなたの勝ち！",
                            font=FNT, fill="cyan")
            cvs.create_text(800, 40, text="時間"+str(int(time.time()-ts)) +
                            "秒", font=FNT, fill="white")
        else:
            cvs.create_text(tmr*10, 300, text="コンピュータの勝ち！",
                            font=FNT, fill="red")
            cvs.create_text(800, 40, text="時間"+str(int(time.time()-ts)) +
                            "秒", font=FNT, fill="white")


def smasher_you():  # マウスポインタの動きに合わせて、プレイヤーのスマッシャーを動かす関数
    global you_x, you_y, you_vx, you_vy
    you_vx = mx-you_x  # プレイヤーのスマッシャーを動かす速さ（1フレームごとにX軸方向に何ドットずつ移動するか）
    you_vy = my-you_y  # プレイヤーのスマッシャーを動かす速さ（1フレームごとにY軸方向に何ドットずつ移動するか）
    you_x = mx
    you_y = my


def smasher_com():  # コンピュータの思考ルーチン
    global com_x, com_y, com_vx, com_vy
    dots = 20+level*10  # コンピュータがスマッシャーを動かす基本的な速さ（ドット数）
    x = com_x
    y = com_y
    if get_dis(com_x, com_y, pu_x, pu_y) < 50*50:  # コンピュータのスマッシャーとパックが重なっているなら
        com_x -= dots  # スマッシャーを左に移動して、パックが右に来るようにする（パックとスマッシャーの位置関係によってはパックを左に押していくこともある）
    elif pu_vx < 4 and com_x < 900:  # パックが左に進むか止まっている、あるいはゆっくり右に進んでいるなら、下の４つのIF文でコンピュータのスマッシャーをパックの位置に向かわせる（com_x < 900という条件式でコンピュータのスマッシャーが画面右端ギリギリまで行かない様にしている）
        if com_y < pu_y-dots:
            com_y += dots
        if com_y > pu_y+dots:
            com_y -= dots
        if com_x < pu_x-dots:
            com_x += dots
        if com_x > pu_x+dots:
            com_x -= dots
    else:  # パックが一定以上の速さで右に進んでいる場合の処理。プレイヤーが打ち込んだパックを弾き返せるコンピュータ側のゴール前の位置である座標（60,300）にコンピュータのスマッシャーを移動させてコンピュータ側のゴールを守るための処理
        com_x += (60-com_x)/(16-level*6)
        com_y += (300-com_y)/(16-level*6)
    com_vx = com_x-x  # コンピュータのスマッシャーを動かす速さ（1フレームごとにX軸方向に何ドットずつ移動するか）
    com_vy = com_y-y  # コンピュータのスマッシャーを動かす速さ（1フレームごとにY軸方向に何ドットずつ移動するか）


def puck_comeout():
    global pu_x, pu_y, pu_vx, pu_vy
    pu_x = 500
    pu_y = 0
    pu_vx = 0
    pu_vy = 20


def puck():  # パックを動かす関数
    global pu_x, pu_y, pu_vx, pu_vy
    r = 20  # パックの半径
    pu_x += pu_vx  # pu_vxの値がパックのX軸方向の速さ
    pu_y += pu_vy  # pu_vyの値がパックのY軸方向の速さ
    # 以下４つのIF文で画面の上下左右にパックが達したかを調べ、画面端に達したらX軸・Y軸方向を反転させてパックが跳ね返るようにする（各軸方向の速さの正負（向き）も調べないと座標と速さによっては上手く跳ね返らないこともある）
    if pu_y < r and pu_vy < 0:
        pu_vy = -pu_vy
    if pu_y > 600-r and pu_vy > 0:
        pu_vy = -pu_vy
    if pu_x < r and pu_vx < 0:
        pu_vx = -pu_vx
    if pu_x > 1000-r and pu_vx > 0:
        pu_vx = -pu_vx
    # 以下４つのIF文で画面外にパックが行かないようにする
    if pu_y < 0:
        pu_y = 0
    if pu_y > 600:
        pu_y = 600
    if pu_x < 0:
        pu_x = 0
    if pu_x > 1000:
        pu_x = 1000
    # パックを少しずつ減速させる
    pu_vx = pu_vx*0.95
    pu_vy = pu_vy*0.95
    # スマッシャーでパックを打つ計算
    if get_dis(pu_x, pu_y, you_x, you_y) < 50*50:
        pu_vx = you_vx*1.2
        pu_vy = you_vy*1.2
    if get_dis(pu_x, pu_y, com_x, com_y) < 50*50:
        pu_vx = com_vx*1.2
        pu_vy = com_vy*1.2


# ２点間の距離（ドット数）を求めてパックとスマッシャーのヒットチェックを行う関数。この関数を呼び出す時は、関数の戻り値＜距離の二乗の様に記述して判定する
def get_dis(x1, y1, x2, y2):
    return (x1-x2)**2+(y1-y2)**2  # √を用いずに二乗した値を返す様にしている


def judge():  # 両サイドにあるゴールにパックが入ったかどうかを調べる関数
    global point_you, point_com
    if pu_x < 20 and 200 < pu_y < 400:  # 左側のゴールにパックが入ったなら
        point_you += 1
        goal[0] = 60  # リストgoal[]はゴールの穴をフラッシュさせる演出で用いられる
        return True
    if pu_x > 980 and 200 < pu_y < 400:  # 右側のゴールにパックが入ったなら
        point_com += 1
        goal[1] = 60
        return True
    return False


def main():
    global mc, proc, tmr, level, point_you, point_com
    tmr += 1
    draw_table()
    if proc == 0 and mc == 1:  # タイトル画面
        mc = 0
        level = 0
        if mx > 500:  # 変数mx（マウスポインタのX座標）の値でNormalモードかHardモードどちらをクリックしたかを判断し、mx > 500だとHardモードを選択
            level = 1
        point_you = 0
        point_com = 0
        puck_comeout()
        proc = 1
    if proc == 1:  # ゲーム中
        puck()
        smasher_you()
        smasher_com()
        if judge() == True:
            puck_comeout()
            if point_you == POINT_WIN or point_com == POINT_WIN:
                proc = 2
                tmr = 0
    if proc == 2 and tmr == 100:  # 勝敗判定
        mc = 0
        proc = 0
    root.after(33, main)


root = tkinter.Tk()
img_title = tkinter.PhotoImage(
    file="pictures/title.png")
img_table = tkinter.PhotoImage(
    file="pictures/table.png")
img_puck = tkinter.PhotoImage(
    file="pictures/puck.png")
img_sma_r = tkinter.PhotoImage(
    file="pictures/smasher_r.png")
img_sma_b = tkinter.PhotoImage(
    file="pictures/smasher_b.png")
root.title("パイソン☆ホッケー")
root.resizable(False, False)
root.bind("<Button>", click)
root.bind("<Motion>", move)
cvs = tkinter.Canvas(width=1000, height=600, bg="black")
cvs.pack()
main()
root.mainloop()
