'use strict';

//位置情報の取得
function success(pos) {
    ajaxRequest(pos.coords.latitude, pos.coords.longitude);
}

function fail(error) {
    switch (error.code) {
        case 1:
            alert('位置情報を取得する許可が無いため、位置情報の取得に失敗しました。エラーコード：' + error.code)
            break;
        case 2:
            alert('何らかのエラーが発生したため、位置情報の取得に失敗しました。エラーコード：' + error.code)
            break;
        case 3:
            alert('制限時間を過ぎたため、位置情報の取得に失敗しました。エラーコード：' + error.code)
            break;
        default:
            break;
    }
}

navigator.geolocation.getCurrentPosition(success, fail);

//UNIX UTCをJavaScriptで扱えるミリ秒に
function utcToJSTime(utcTime) {
    return utcTime * 1000;
}
//天気予報データの取得
function ajaxRequest(lat, long) {
    const url = 'https://api.openweathermap.org/data/2.5/forecast';
    const appId = '5d083c9f54cc3dff3da63007e89c2e95';//API Key

    $.ajax({
        url: url,
        data: {
            appid: appId,
            lat: lat,
            lon: long,
            units: 'metric',
            lang: 'ja'
        }
    })
        .done(function (data) {
            console.log(data);

            //都市名、国名
            /*console.log('都市名：' + data.city.name);
            console.log('国名：' + data.city.country);*/
            //変更点：HTMLの特殊文字（&emsp;）を使うために、jQueryのtextメソッドをhtmlメソッドに変更
            $('#place').html('都市名：' + data.city.name + '&emsp;' + '国名：' + data.city.country);

            //天気予報データ
            data.list.forEach(function (forecast, index) {
                const datetime = new Date(utcToJSTime(forecast.dt));
                const mouth = datetime.getMonth() + 1;
                const date = datetime.getDate();
                const hours = datetime.getHours();
                const min = String(datetime.getMinutes()).padStart(2, '0');
                //変更点：気温を小数点第一位まで表示に変更
                const temperature = Math.round(forecast.main.temp * 10) / 10;
                const description = forecast.weather[0].description;
                const iconPath = `images/${forecast.weather[0].icon}.svg`;

                /*console.log('日時：' + `${mouth}/${date}　${hours}：${min}`);
                console.log('気温：' + temperature);
                console.log('天気：' + description);
                console.log('画像パス：' + iconPath);*/
                //現在の天気は大きく表示し、それ以外の天気は表で表示
                if (index === 0) {
                    const currentWeather = `
                    <div class="icon"><img src="${iconPath}"></div>
                    <div class="info">
                    <p>
                    <span class="description">現在の天気：${description}</span>
                    <span class="temp">${temperature}</span>°C
                    </p>
                    </div>
                    `;
                    $('#weather').html(currentWeather);
                } else {
                    const tableRow = `
                    <tr>
                    <td class="info">
                    ${mouth}/${date}　${hours}：${min}
                    </td>
                    <td class="icon"><img src="${iconPath}"></td>
                    <td><span class="description">${description}</span></td>
                    <td><span class="temp">${temperature}</span>°C</td>
                    </tr>
                    `;
                    $('#forecast').append(tableRow);
                }
            });
        })
        .fail(function () {
            console.log('$.ajax failed!');
        })
}
